close all
clear all

%--------------------------------------------------------------------------
%Onsets und Durations einlesen
%--------------------------------------------------------------------------

%ONSETS
[ons_name,folder_name2]=uigetfile('*.*','Onsets?');
cd(folder_name2);
onsets=importdata(ons_name);
onsets=round(onsets);
dim_ons=numel(onsets);


%DURATIONS
[Dur_name,folder_name3]=uigetfile('*.*','Durations?');
cd(folder_name3);
Duration=importdata(Dur_name);
Duration=round(Duration);
dim_dur=numel(Duration);

%--------------------------------------------------------------------------
%Stimulations train
%--------------------------------------------------------------------------
X = zeros(1795,1);          %1795 = Anzahl Bilder im MRI Scan
for i=1:dim_ons
    dummy=onsets(i);
    X(dummy,1)=1;
    if Duration(i)== 2
        X(dummy+1,1)=1;
    end
    if Duration(i) == 3
        X(dummy+1,1)=1;
        X(dummy+2,1)=1;
    end
end
X=X/1000;

%--------------------------------------------------------------------------
%Falten mit HRF
%--------------------------------------------------------------------------

[HRF_name,folder_name4]=uigetfile('*.*','HRF?');
cd(folder_name4);
HRF=importdata(HRF_name);
dim_HRF=numel(HRF);
figure(2)
plot(HRF)

%--------------------------------------------------------------------------
%Faltung
%--------------------------------------------------------------------------
Regressor = conv(X,HRF);
Regressor(1796:1810)=[];
figure(3)
plot(Regressor)